'Word Scramble with a list of videogames
option base 1
dim string a$, s$, o$, dd$, ii$, dword$ length 60
dim string scrambled$ length 60, temp$ length 60, tempa$(20)
dim integer dnum, i, j, d, l, n, c
dim integer byte_selected, data_word_num, num_data_words
dim integer num_words_selected, num_word_asked, dat_file_bytes
dim integer posx, charbegin, score

mode 9, 16
font 4 '10x16 pixels
initial = 0 : score = 0 : num_data_words = 139857

another:
cls
num_word_asked = 0 : num_word_selected = 0

if initial = 0 then 
  data_word_num = 1 : color rgb(green)
  print @(0,  0) "Word Scramble Videogames"
  print @(0, 32) "Gameplay keys include letters A-Z, numbers,"
  print @(0, 48) "hyphen, enter, and space bar"
  open "/Word Scramble/DAT/Videogames 60 139857.dat" for random as #1
  dat_file_bytes = mm.info(filesize "/Word Scramble/DAT/Videogames 60 139857.dat") 'Find the length of the .dat file
endif

initial = 1 : data_word_num = 1

do  
  cls
  byte_selected = int(rnd * dat_file_bytes + 1) 'select a random byte 
  if byte_selected + 60 > dat_file_bytes then inc byte_selected, -60 'back up at least one line so we do retrieve data
  seek #1, byte_selected
  line input #1, dword$
  dword$ = "" 'just want to scrap what we read, because we want to start at the BEGINNING of a line
  line input #1, dword$
  show_score()
  scramble()
  show_scrambled()
  guess() 
loop    

sub show_score
  font 4 '10x16 pixels
  color rgb(green)
  print @(20, 700) "Data phrases: ";addcomma$(num_data_words) 
  print @(20, 732) "Score: ";addcomma$(score)
end sub

sub scramble
  for i = 1 to 20 : tempa$(i) = "" : next i
  charbegin = 1 : scrambled$ = ""
  temp$ = lcase$(dword$)
  for i = 1 to 20
    if instr(charbegin, temp$, " ") = 0 then tempa$(i) = mid$(temp$, charbegin) : exit for
    tempa$(i) = mid$(temp$, charbegin, instr(charbegin, temp$, " ") - charbegin)
    charbegin = instr(charbegin, temp$, " ") + 1
  next i
  for i = 1 to 20
    if tempa$(i) = "" then exit for
    for j = 1 to len(tempa$(i))
      do
        posx = int(rnd * len(tempa$(i)) + 1)
        if mid$(tempa$(i), posx, 1) <> "@" then exit do
      loop
      scrambled$ = scrambled$ + mid$(tempa$(i), posx, 1)
      mid$(tempa$(i), posx, 1) = "@" '@ = character/letter has been used
    next j
    if tempa$(i + 1) <> "" then scrambled$ = scrambled$ + " "
  next i
end sub

sub show_scrambled
  font 3, 2 '32x48 pixels
  color rgb(green)
  for i = 1 to len(scrambled$)
    if i < 26 then
      print @((i - 1) * 37 + 16, 100) mid$(scrambled$, i, 1)
      line (i - 1) * 37 + 16, 150, (i - 1) * 37 + 48, 150, 3, rgb(red)
    elseif i > 25 and i < 51 then
      print @((i - 26) * 37 + 16, 170) mid$(scrambled$, i, 1)
      line (i - 26) * 37 + 16, 220, (i - 26) * 37 + 48, 220, 3, rgb(red)
    else 'i > 50
      print @((i - 51) * 37 + 16, 240) mid$(scrambled$, i, 1)
      line (i - 51) * 37 + 16, 290, (i - 51) * 37 + 48, 290, 3, rgb(red)
    endif
  next i
end sub

sub guess
  a$ = ""
  color rgb(yellow) : font 3, 1
  print @(0, 350) "What is the game shown above"
  input a$
  a$ = lcase$(a$)
  if a$ = lcase$(dword$) then
    print @(0, 450) "That is correct."
    inc score, len(dword$)
  else
    print @(0, 450) "That is wrong."
    print @(0, 474) "The correct answer is ";dword$
    inc score, -3
  endif
  pause 600
  do
    if keydown(1) = 10 or keydown(1) = 32 then exit do 'If user presses enter or space bar
  loop
end sub

function addcomma$(v)
  addcomma$ = "" : s$ = "" : o$ = "" : dd$ = "" : ii$ = ""
  d = 0 : i = 0 : l = 0 : n = 0 : c = 0
  if v < 0 then s$ = "-" : v = abs(v)
  i = int(v)
  d = v - i
  if d <> 0 then dd$ = mid$(str$(d), 2)
  ii$ = str$(i)
  l = len(ii$)
  for n = l to 1 step -1
    inc c
    if c = 4 then c = 1 : o$ = "," + o$
    o$ = mid$(ii$, n, 1) + o$
  next n
  addcomma$ = s$ + o$ + dd$
end function

